unit Plane;
{Demonstrates 2-d-graphing with TMathImage. I've set all the real types
here to double to demonstrate that TMathImage can be used with any float
type. Parts that make use of TMathImage are marked ***********}

interface

uses
  SysUtils,
  {$IFDEF WINDOWS}
  WinTypes, WinProcs,
  {$ENDIF}
  {$IFDEF WIN32}
  Windows,
  {$ENDIF}
  Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Mathimge;

type
  TPlaneGraphs = class(TForm)
    ColorDialog1: TColorDialog;
    Panel2: TPanel;
    xshow: TLabel;
    yshow: TLabel;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Periods: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Button1: TButton;
    F1line: TEdit;
    F2line: TEdit;
    Button2: TButton;
    Meshline: TEdit;
    Pline: TEdit;
    CheckBox1: TCheckBox;
    x1edit: TEdit;
    x2edit: TEdit;
    y1edit: TEdit;
    y2edit: TEdit;
    Label8: TLabel;
    Button3: TButton;
    Button4: TButton;
    GraphImage: TMathImage;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure GraphImageMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure F1lineChange(Sender: TObject);
    procedure F2lineChange(Sender: TObject);
    procedure PlineChange(Sender: TObject);
    procedure MeshlineChange(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure GraphImageMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure GraphImageMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    graphcolor:longint;
    f1,f2,p:double;
    mesh:integer;
    xorg,yorg,xmov,ymov:integer;
    xxorg,yyorg,xxmov,yymov:extended;
    beginBox, Boxing:boolean;
    procedure CreateParams(var Params: TCreateParams); override;
    function getf1:double;
    function getf2:double;
    function getp:double;
    function getmesh:integer;
    function r(o:double):double;
    { Private declarations }
  public
    { Public declarations }
  end;

  var PlaneGraphs:TPlaneGraphs;

implementation

uses MDemo1;

{$R *.DFM}

procedure TPlaneGraphs.CreateParams(var Params: TCreateParams);
begin
  inherited  CreateParams(Params);
  with Params do
  begin
    WndParent := Demoform.Handle;
    Parent := Demoform;
    Style := WS_CHILD OR WS_CLIPSIBLINGS OR WS_CLIPCHILDREN;
    Align := alClient;
  end;
end;

function TPlaneGraphs.getf1;
var x:double; c:integer;
begin
  val(f1line.text,x,c);
  if c=0 then getf1:=x;
end;

function TPlaneGraphs.getf2;
var x:double; c:integer;
begin
  val(f2line.text,x,c);
  if c=0 then getf2:=x;
end;

function TPlaneGraphs.getp;
var x:double; c:integer;
begin
  val(pline.text,x,c);
  if c=0 then getp:=x;
end;

function TPlaneGraphs.getmesh;
var i,c:integer;
begin
  val(meshline.text,i,c);
  if c=0 then getmesh:=i;
end;

function TPlaneGraphs.r;
begin
  r:=sin(o*f1)+cos(o*f2);
end;


procedure TPlaneGraphs.Button2Click(Sender: TObject);
begin
  with colordialog1 do
  if execute then
  begin
    graphcolor:=color;
    Button1Click(Self);
  end;
end;

{**************************************}
procedure TPlaneGraphs.Button1Click(Sender: TObject);
var i:integer; o:double;
begin
  Screen.Cursor:=CrHourGlass;
  with graphimage do
  begin
    setworld(strtofloat(x1edit.text),strtofloat(y1edit.text),
             strtofloat(x2edit.text),strtofloat(y2edit.text));
    clear;
    setcolor(graphcolor);
    if checkbox1.checked then
    begin
      canvas.font.name:='Arial';
      canvas.font.size:=9;
      canvas.font.style:=[fsitalic,fsbold];
      d2axes:=true;
    end else d2axes:=false;
    movetopoint(r(0),0);
    for i:=1 to mesh do
    begin
      o:=i*2*p*Pi/mesh;
      drawlineto(r(o)*cos(o),r(o)*sin(o));
    end;
    if checkbox1.checked then
    drawaxes('x','y',true,clblack,clred);
  end;
  Screen.Cursor:=CrDefault;
end;

{************************************}
procedure TPlaneGraphs.FormResize(Sender: TObject);
begin
  graphimage.reset;
  application.processmessages;
  button1click(self);
end;

{****************************************}
procedure TPlaneGraphs.GraphImageMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  with GraphImage do
  begin
    xshow.caption:=floattostrf(worldx(x),ffgeneral,5,5);
    yshow.caption:=floattostrf(worldy(y),ffgeneral,5,5);
    if boxing then with canvas do
    begin
      pen.color:=clred;
      pen.mode:=pmNotXor;
      brush.style:=bsclear;
      rectangle(xorg,yorg,xmov,ymov);
      xmov:=x; ymov:=y;
      rectangle(xorg,yorg,xmov,ymov);
    end;
  end;
end;

{************************}
procedure TPlaneGraphs.FormCreate(Sender: TObject);
begin
  with graphimage do
  begin
    d2worldx1:=-1; d2worldx2:=1;
    d2worldy1:=-1; d2worldy2:=1;
    d2axes:=false;
    graphcolor:=clolive;
    f1:=getf1; f2:=getf2; p:=getp; mesh:=getmesh;
    BeginBox:=false; Boxing:=False;
  end;
end;

procedure TPlaneGraphs.F1lineChange(Sender: TObject);
begin
  f1:=getf1;
end;

procedure TPlaneGraphs.F2lineChange(Sender: TObject);
begin
  f2:=getf2;
end;

procedure TPlaneGraphs.PlineChange(Sender: TObject);
begin
  p:=getp;
end;

procedure TPlaneGraphs.MeshlineChange(Sender: TObject);
begin
  mesh:=getmesh;
end;






procedure TPlaneGraphs.Button3Click(Sender: TObject);
var w,h,x,y:extended;
begin
  with graphimage do
  begin
    w:=(d2worldx2-d2worldx1)*4/3;
    h:=(d2worldy2-d2worldy1)*4/3;
    x:=(d2worldx1+d2worldx2-w)/2;
    y:=(d2worldy1+d2worldy2-h)/2;
    x1edit.text:=FloatToStrF(x,ffgeneral,4,4);
    x2edit.text:=FloatToStrF(x+w,ffgeneral,4,4);
    y1edit.text:=FloatToStrF(y,ffgeneral,4,4);
    y2edit.text:=FloatTostrF(y+h,ffgeneral,4,4);
  end;
  button1click(self);
end;

procedure TPlaneGraphs.Button4Click(Sender: TObject);
var savecolor:TColor;
begin
  Screen.Cursor:=crCross;
  BeginBox:=true;
end;

procedure TPlaneGraphs.GraphImageMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  If shift=[ssleft] then if beginbox then
  with graphimage do begin
    boxing:=true;
    xorg:=x; yorg:=y;
    xmov:=x; ymov:=y;
    xxorg:=worldx(x); yyorg:=worldy(y);
  end;
end;

procedure TPlaneGraphs.GraphImageMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  If boxing then
  with graphimage do
  begin
    boxing:=false;
    beginbox:=false;
    canvas.rectangle(xorg,yorg,xmov,ymov);
    xxmov:=worldx(x); yymov:=worldy(y);
    canvas.brush.style:=bsSolid;
    canvas.pen.mode:=pmCopy;
    if xxorg<xxmov then if yyorg>yymov then
    begin
      x1edit.text:=FloatToStrf(xxorg,ffgeneral,4,4);
      x2edit.text:=FloatToStrf(xxmov,ffgeneral,4,4);
      y1edit.text:=FloatToStrf(yymov,ffgeneral,4,4);
      y2edit.text:=FloatToStrf(yyorg,ffgeneral,4,4);
      button1click(self);
    end;
    Screen.Cursor:=crDefault;
  end;
end;

end.
